<?php
namespace Pawn;

class Controller
{
	private $vars = array();
	
	public function __construct()
	{
		
	}
	
	public function render($file, $vars=array())
	{
		return \lib\Template::render($file, $vars);
	}
	
	public function json($data, $output=true)
	{
		$json = json_encode($data);
		
		if($output)
		{
			echo $json;
		}
		
		return $json;
	}
	
	public function redirect()
	{
		header('Location: '.call_user_func_array(array('\Pawn', 'path'), func_get_args()));
		
		exit;
	}
	
	public function not_found()
	{
		\lib\Lang::load('not_found');
		
		return \lib\Template::render('error/404.html', array
		(
			'home_page'		=>	'<a href="'.WEB.'">{value}</a>'
		));
	}
	
	public function __get($key)
	{
		return isset($this->vars[$key])?$this->vars[$key]:null;
	}
	
	public function __set($key, $value)
	{
		global $autoload;
		
		if(isset($autoload['Session']) && isset($autoload['Session'][$key]))
		{
			$autoload['Session'][$key] = $value;
		}
		
		if(class_exists('\\lib\\Template', false))
		{
			\lib\Template::vars(array($key=>$value));
		}
		
		$this->vars[$key] = $value;
	}
}